<?php
declare(strict_types=1);

namespace Application\Block\HelloWorld;

use Concrete\Core\Block\BlockController;

class Controller extends BlockController
{

    protected $btTable = "btHelloWorld";
    protected $btInterfaceWidth = "350";
    protected $btInterfaceHeight = "240";
    protected $btDefaultSet = 'basic';

    public function getBlockTypeName(): string
    {
        return t('Hello World');
    }

    public function getBlockTypeDescription(): string
    {
        return t('A simple starting block for developers');
    }

    public function validate($args)
    {
        $error = parent::validate($args);
        if (!is_array($args)) {
            $error->add('Invalid data type, data must be an array.');
            return $error;
        }

        $field1 = $args['field1'] ?? null;
        if (!$field1) {
            $error->add(t('You must put something in the field 1 box.'));
        }

        return $error;
    }

    public function save($args): void
    {
        // Convert given boolean field from string to true/false
        $args['booleanfield'] = filter_var($args['booleanfield'] ?? false, FILTER_VALIDATE_BOOLEAN) ? 1 : 0;
        parent::save($args);
    }
}
